﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace PowerAmpDemoNS
{
    public partial class PowerAmpDemoProgram
    {
        // Test Procedures
        public int cdma2000Test()
        {
            // Configure variables for WCDMA Standard
            string testWaveform = cdma2000Arb;
            string testName = "cdma2000 Test";
            vsag.setupParameters("CDMA2000");
            dataLog.tstName = "CDMA2K";

            dataLog.addResultsHeader(testName);
            //Start Test timer
            sw.Reset();
            sw.Start();

            // Setup the VSG and VSA for waveform, band frequency and power level
            vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain);

            // Configure the EVM measurement
            if (testEvm)
                vsag.configEvDoRhoMeas("MS", cellFreqs[0], targetPout);

            // Loop over Frequencies for Low Band
            for (int i = 0; i < cellFreqs.Length; i++)
            {
                dataLog.addResultsHeader("Frequency = " + (cellFreqs[i] / 1e6).ToString("0.0") +
                    " MHz, Output Power = " + targetPout.ToString("0.00") + " dBm");

                // Set VSG and VSA to test frequency
                vsag.setTestFreq(cellFreqs[i]);

                // Servo source until Pout is at correct value
                if (vsag.fftServo)
                    vsag.servoInputPowerFft(targetPout, poutMargin);
                else
                    vsag.servoInputPower(targetPout, poutMargin);

                if (testCurr)
                {
                    // Measure DC Current
                    dcSmu.measCurrent();
                }

                if (testAcpr)
                {
                    // Use the IVI Driver to Measure ACPR
                    if (vsag.fftAcpr)
                        vsag.measFftAcpr();
                    else
                        vsag.measStdAcpr();
                }

                if (testEvm)
                {
                    // Measure EVM with X-App
                    // Unlock receiver from driver before starting, lock receiver and update setup when complete
                    vsag.unlockVsa();
                    vsag.setXappFreq(cellFreqs[i]);
                    vsag.measEvDoRho();
                    vsag.lockVsa();
                    
                    vsag.setupVsa(cellFreqs[i], targetPout);
                }

                if (testHarms)
                {
                    // Measure Harmonics using Spectrum Method
                    vsag.measSpecHarms(true, true);
                }

                // Tests complete, setup for next test
                dataLog.nextTest();
            }
            // Update results and data log for end of test
            dataLog.addResultsFooter(testName, sw.ElapsedMilliseconds);
            return 0;
        }
    }
}